<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class R2CC_Cookie_Categories {

    /**
     * Get all predefined categories
     */
    public static function get_categories() {
        return array(
            'necessary' => array(
                'label'       => __( 'Strictly Necessary', 'rise2-cookie-consent' ),
                'description' => __( 'These cookies are essential for the website to function properly. They enable basic features like page navigation, secure areas access, and shopping cart functionality. The website cannot function properly without these cookies, and they are always enabled.', 'rise2-cookie-consent' ),
                'is_required' => true,
                'default_on'  => true,
                'icon'        => 'shield',
            ),
            'functional' => array(
                'label'       => __( 'Functional', 'rise2-cookie-consent' ),
                'description' => __( 'Functional cookies enable the website to provide enhanced functionality and personalization. They may be set by us or by third-party providers whose services we have added to our pages. If you do not allow these cookies, some or all of these services may not function properly.', 'rise2-cookie-consent' ),
                'is_required' => false,
                'default_on'  => false,
                'icon'        => 'settings',
            ),
            'analytics' => array(
                'label'       => __( 'Analytics & Performance', 'rise2-cookie-consent' ),
                'description' => __( 'These cookies allow us to count visits and traffic sources so we can measure and improve the performance of our site. They help us understand which pages are the most and least popular and see how visitors move around the site. All information these cookies collect is aggregated and therefore anonymous.', 'rise2-cookie-consent' ),
                'is_required' => false,
                'default_on'  => false,
                'icon'        => 'chart',
            ),
            'marketing' => array(
                'label'       => __( 'Marketing & Advertising', 'rise2-cookie-consent' ),
                'description' => __( 'These cookies may be set through our site by our advertising partners. They may be used by those companies to build a profile of your interests and show you relevant advertisements on other sites. They do not directly store personal information but uniquely identify your browser and internet device.', 'rise2-cookie-consent' ),
                'is_required' => false,
                'default_on'  => false,
                'icon'        => 'megaphone',
            ),
        );
    }

    /**
     * Seed default cookie entries for common WordPress cookies
     */
    public static function seed_defaults() {
        $existing = R2CC_Cookie_Database::get_cookies();
        if ( ! empty( $existing ) ) {
            return; // Already seeded
        }

        $domain = parse_url( home_url(), PHP_URL_HOST );

        $defaults = array(
            // Cookie consent cookie itself
            array(
                'cookie_name' => 'r2cc_consent',
                'category'    => 'necessary',
                'domain'      => $domain,
                'duration'    => '365 days',
                'description' => 'Stores the cookie consent preferences chosen by the visitor.',
            ),
            array(
                'cookie_name' => 'r2cc_consent_uid',
                'category'    => 'necessary',
                'domain'      => $domain,
                'duration'    => '365 days',
                'description' => 'A unique anonymous identifier used to log and verify consent records.',
            ),
            // WordPress core
            array(
                'cookie_name' => 'wordpress_test_cookie',
                'category'    => 'necessary',
                'domain'      => $domain,
                'duration'    => 'Session',
                'description' => 'Used to check if the browser accepts cookies. Contains no personal data.',
            ),
            array(
                'cookie_name' => 'wordpress_logged_in_*',
                'category'    => 'necessary',
                'domain'      => $domain,
                'duration'    => 'Session / 14 days',
                'description' => 'Identifies the logged-in user after authentication.',
                'is_regex'    => 1,
            ),
            array(
                'cookie_name' => 'wp-settings-*',
                'category'    => 'functional',
                'domain'      => $domain,
                'duration'    => '1 year',
                'description' => 'Stores WordPress admin dashboard customization preferences.',
                'is_regex'    => 1,
            ),
        );

        foreach ( $defaults as $cookie ) {
            R2CC_Cookie_Database::save_cookie( $cookie );
        }
    }

    /**
     * Get category label by slug
     */
    public static function get_category_label( $slug ) {
        $categories = self::get_categories();
        return isset( $categories[ $slug ] ) ? $categories[ $slug ]['label'] : ucfirst( $slug );
    }

    /**
     * Get category options for select fields
     */
    public static function get_category_options() {
        $categories = self::get_categories();
        $options = array();
        foreach ( $categories as $slug => $cat ) {
            $options[ $slug ] = $cat['label'];
        }
        return $options;
    }
}
